<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddLessonIdToExamQuestionsTable extends Migration
{
    public function up()
    {
        Schema::table('exam_questions', function (Blueprint $table) {
            $table->unsignedBigInteger('Lesson_id')->nullable()->after('Content_id');
            $table->foreign('Lesson_id')->references('Lesson_id')->on('lessons')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('exam_questions', function (Blueprint $table) {
            $table->dropForeign(['Lesson_id']);
            $table->dropColumn('Lesson_id');
        });
    }
}
